<?php
/**
 * tara functions and definitions
 * @package tara
 */

if ( ! function_exists( 'tara_setup' ) ) :
	function tara_setup() {
		load_theme_textdomain( 'tara', get_template_directory() . '/languages' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );
		register_nav_menus( array(
			'menu-1' => esc_html__( 'Primary', 'tara' ),
		) );  
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'tara_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 110,
			'width'       => 178,
			'flex-width'  => true,
			'flex-height' => true,
		) );
	}
endif;
add_action( 'after_setup_theme', 'tara_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function tara_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'tara_content_width', 640 );
}
add_action( 'after_setup_theme', 'tara_content_width', 0 );
function tara_widgets_init() {
    //Icon
    register_sidebar( array(
		'name'          => esc_html__( 'Icon MXH', 'tara' ),
		'id'            => 'icon',
		'description'   => esc_html__( 'Add widgets here.', 'tara' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<span class="title-ft">',
		'after_title'   => '</span>',
	) ); 
	//slide
    register_sidebar( array(
		'name'          => esc_html__( 'Slide Show', 'tara' ),
		'id'            => 'slide',
		'description'   => esc_html__( 'Add widgets here.', 'tara' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<span class="title-ft">',
		'after_title'   => '</span>',
	) ); 
    
    //slide
    register_sidebar( array(
		'name'          => esc_html__( 'Slide Show Landing Page', 'tara' ),
		'id'            => 'slide1',
		'description'   => esc_html__( 'Add widgets here.', 'tara' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<span class="title-ft">',
		'after_title'   => '</span>',
	) ); 
    //breadcrumb
    register_sidebar( array(
		'name'          => esc_html__( 'Breadcrumb', 'tara' ),
		'id'            => 'breadcrumb',
		'description'   => esc_html__( 'Add widgets here.', 'tara' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<span class="">',
		'after_title'   => '</span>',
	) ); 
    register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'tara' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'tara' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
    
    //ho tro
    register_sidebar( array(
		'name'          => esc_html__( 'Hỗ Trợ', 'tara' ),
		'id'            => 'ho-tro',
		'description'   => esc_html__( 'Add widgets here.', 'tara' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<div class="widget-title">',
		'after_title'   => '</div>',
	) ); 
    
    //Service Top
    register_sidebar( array(
		'name'          => esc_html__( 'Service Top', 'tara' ),
		'id'            => 'service-top',
		'description'   => esc_html__( 'Add widgets here.', 'tara' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
    
    //Dịch vụ
    register_sidebar( array(
		'name'          => esc_html__( 'Dịch Vụ', 'tara' ),
		'id'            => 'dich-vu',
		'description'   => esc_html__( 'Add widgets here.', 'tara' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<span class="widget-title">',
		'after_title'   => '</span>',
	) );
    
    //Tại sao
    register_sidebar( array(
		'name'          => esc_html__( 'Tại Sao', 'tara' ),
		'id'            => 'tai-sao',
		'description'   => esc_html__( 'Add widgets here.', 'tara' ),
		'before_widget' => '<section class="taisao tt-home">',
		'after_widget'  => '</section>',
		'before_title'  => '<span class="taisao-title">',
		'after_title'   => '</span>',
	) );
    
    //Nhân Viên
     register_sidebar( array(
		'name'          => esc_html__( 'Đội ngủ nhân viên', 'tara' ),
		'id'            => 'nhan_vien',
		'description'   => esc_html__( 'Add widgets here.', 'tara' ),
		'before_widget' => '<section>',
		'after_widget'  => '</section>',
		'before_title'  => '<span class="header-top">',
		'after_title'   => '</span>',
	) );
    
    //Tin Tức
     register_sidebar( array(
		'name'          => esc_html__( 'Tin Tức', 'tara' ),
		'id'            => 'tin_tuc',
		'description'   => esc_html__( 'Add widgets here.', 'tara' ),
		'before_widget' => '<section>',
		'after_widget'  => '</section>',
		'before_title'  => '<span class="header-top">',
		'after_title'   => '</span>',
	) );
    //Form Liên Hệ
     register_sidebar( array(
		'name'          => esc_html__( 'Form Liên Hệ', 'tara' ),
		'id'            => 'form_lh',
		'description'   => esc_html__( 'Add widgets here.', 'tara' ),
		'before_widget' => '<section>',
		'after_widget'  => '</section>',
		'before_title'  => '<span>',
		'after_title'   => '</span>',
	) );
    //Hoạt động hàng ngày
     register_sidebar( array(
		'name'          => esc_html__( 'Hoạt động hàng ngày', 'tara' ),
		'id'            => 'hoat_dong',
		'description'   => esc_html__( 'Add widgets here.', 'tara' ),
		'before_widget' => '<section>',
		'after_widget'  => '</section>',
		'before_title'  => '<span >',
		'after_title'   => '</span>',
	) );
    
    //Footer logo
     register_sidebar( array(
		'name'          => esc_html__( 'Footer Logo', 'tara' ),
		'id'            => 'ft-gt',
		'description'   => esc_html__( 'Add widgets here.', 'tara' ),
		'before_widget' => '<section class="ft-gt">',
		'after_widget'  => '</section>',
		'before_title'  => '<div class="tt-ft">',
		'after_title'   => '</div>',
	) );
    //Footer giới thiệu
     register_sidebar( array(
		'name'          => esc_html__( 'Footer Giới thiệu', 'tara' ),
		'id'            => 'ft-cnit',
		'description'   => esc_html__( 'Add widgets here.', 'tara' ),
		'before_widget' => '<section class="ft-cnit">',
		'after_widget'  => '</section>',
		'before_title'  => '<div class="tt-ft">',
		'after_title'   => '</div>',
	) );
 
    //Footer Liên Kết
     register_sidebar( array(
		'name'          => esc_html__( 'Footer Liên Kết', 'tara' ),
		'id'            => 'ft-bg',
		'description'   => esc_html__( 'Add widgets here.', 'tara' ),
		'before_widget' => '<section class="ft-bg">',
		'after_widget'  => '</section>',
		'before_title'  => '<div class="tt-ft">',
		'after_title'   => '</div>',
	) );
    
    //Footer Liên Hệ
     register_sidebar( array(
		'name'          => esc_html__( 'Footer Hotline', 'tara' ),
		'id'            => 'ft-lh',
		'description'   => esc_html__( 'Add widgets here.', 'tara' ),
		'before_widget' => '<section class="ft-lh">',
		'after_widget'  => '</section>',
		'before_title'  => '<div class="tt-ft">',
		'after_title'   => '</div>',
	) );
    

}
add_action( 'widgets_init', 'tara_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function tara_scripts() {
	wp_enqueue_style( 'tara-style', get_stylesheet_uri() );
	wp_enqueue_script( 'tara-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20151215', true );
	wp_enqueue_script( 'tara-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20151215', true );
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'tara_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}
// tro ve trinh soan thao cu
add_filter('use_block_editor_for_post', '__return_false');
//funtion cat ky tu theo yeu cau
function the_content_max_charlength($charlength) {
	$excerpt = get_the_content();
	$charlength++;

	if ( mb_strlen( $excerpt ) > $charlength ) {
		$subex = mb_substr( $excerpt, 0, $charlength - 5 );
		$exwords = explode( ' ', $subex );
		$excut = - ( mb_strlen( $exwords[ count( $exwords ) - 1 ] ) );
		if ( $excut < 0 ) {
			echo mb_substr( $subex, 0, $excut );
		} else {
			echo $subex;
		}
		echo '[...]';
	} else {
		echo $excerpt;
	}
}
//funtion cat ky tu theo yeu cau
function the_excerpt_max_charlength($charlength) {
	$excerpt = get_the_excerpt();
	$charlength++;

	if ( mb_strlen( $excerpt ) > $charlength ) {
		$subex = mb_substr( $excerpt, 0, $charlength - 5 );
		$exwords = explode( ' ', $subex );
		$excut = - ( mb_strlen( $exwords[ count( $exwords ) - 1 ] ) );
		if ( $excut < 0 ) {
			echo mb_substr( $subex, 0, $excut );
		} else {
			echo $subex;
		}
		echo '[...]';
	} else {
		echo $excerpt;
	}
}
//funtion cat ky tu title theo yeu cau
        function the_max_title($charlength) {
        	$max_title = get_the_title();
        	$charlength++;
        	if ( mb_strlen( $max_title ) > $charlength ) {
        		$subex = mb_substr( $max_title, 0, $charlength - 5 );
        		$exwords = explode( ' ', $subex );
        		$excut = - ( mb_strlen( $exwords[ count( $exwords ) - 1 ] ) );
        		if ( $excut < 0 ) {
        			echo mb_substr( $subex, 0, $excut );
        		} else {
        			echo $subex;
        		}
        		echo '...';
        	} else {
        		echo $max_title;
        	}
        }
// dang ky menu mac dinh
function register_my_menu() {
  register_nav_menu('menu-serviecs',__( 'Menu Services' ));
  register_nav_menu('menu-top',__( 'Menu Top' ));
}
add_action( 'init', 'register_my_menu' );
//loai bo chu archve
add_filter( 'get_the_archive_title', function ($title) {
    if ( is_category() ) {
        $title = single_cat_title( '', false );
    } elseif ( is_tag() ) {
        $title = single_tag_title( '', false );
    } elseif ( is_author() ) {
        $title = '<span>' . get_the_author() . '</span>' ;
    }
    return $title;
});

add_action('init', 'VnKings_change_page_permalink', -1);
function VnKings_change_page_permalink() {
    global $wp_rewrite;
    if ( strstr($wp_rewrite->get_page_permastruct(), '.html') != '.html' )
    $wp_rewrite->page_structure = $wp_rewrite->page_structure . '.html';
}
add_action( 'rewrite_rules_array', 'rewrite_rules' );
function rewrite_rules( $rules ) {
    $new_rules = array();
    foreach ( get_post_types() as $t )
        $new_rules[ $t . '/([^/]+)\.html$' ] = 'index.php?post_type=' . $t . '&name=$matches[1]';
    return $new_rules + $rules;
}
add_filter( 'post_type_link', 'custom_post_permalink' ); // for cpt post_type_link (rather than post_link)
function custom_post_permalink ( $post_link ) {
    global $post;
    $type = get_post_type( $post->ID );
    return home_url( $type . '/' . $post->post_name . '.html' );
}

/**
 * them the alt
 */
add_filter('wp_get_attachment_image_attributes', 'change_attachement_image_attributes', 20, 2);
function change_attachement_image_attributes( $attr, $attachment ){
    // Get post parent
    $parent = get_post_field( 'post_parent', $attachment);
    // Get post type to check if it's product
    $type = get_post_field( 'post_type', $parent);
    if( $type != 'product' ){
        return $attr;
    }
    /// Get title
    $title = get_post_field( 'post_title', $parent);
    $attr['alt'] = $title;
    $attr['title'] = $title;
    return $attr;
}

function wpdocs_post_image_html( $html, $post_id, $post_image_id ) {
    $html = '<a href="' . get_permalink( $post_id ) . '" alt="' . esc_attr( get_the_title( $post_id ) ) . '">' . $html . '</a>';
    return $html;
}
add_filter( 'post_thumbnail_html', 'wpdocs_post_image_html', 10, 3 );
add_post_type_support( 'page', 'excerpt' );//them excerpt cho web 

// tro ve widget cu
add_filter( 'gutenberg_use_widgets_block_editor', '__return_false' );
add_filter( 'use_widgets_block_editor', '__return_false' );