<?php
/*
 * Plugin Name: Slide Show
 * Plugin URI: https://#
 * Description: Widget that displays the featured image of the current post.
 * Version: 1.0
 * Author: Quyen Ga
 * Author URI: https://#
 * License: Q
 * 
 * @package ng-sidebar-featured-image
 * @copyright Copyright (c) 2016, Quyen Ga.
 * @license Q
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
class slide_quyen extends WP_Widget
{
    function __construct()
    {
        parent::__construct(
                'slide_quyen',
                __( 'SLIDE SHOW', 'ctm' ),
                array('description' => __( 'This plugin displays a list of products of a certain category on your website 1.', 'ctm' )) 
                );
    }
    public function widget( $args, $instance ) {
        extract( $args );
        $title = apply_filters( 'widget_title', $instance['title']);
        $ids   = $instance['ids'];
        $text  = $instance['text'];
        $text1  = $instance['text1'];
        $text2  = $instance['text2'];
         ?>
      <div id="slide">
        <div class="slider slider_one_big_picture">
            <?php echo $text; ?>
         <div class="next_button"></div>  
          <div class="prev_button"></div>  
          <div class="nav_indicators"></div>
         </div>
         <script>
           $(document).ready(function() {
             $('.slider_one_big_picture').EasySlides({'autoplay': true,'stepbystep':false, 'show': 5})
             $('.slider_circle_10').EasySlides({'autoplay': true, 'show': 13})
             $('.slider_four_in_line').EasySlides({'autoplay': true, 'show': 9})
             $('.slider_clock').EasySlides({'autoplay': true, 'show': 15})
        
           });
         </script>
        <script type="text/javascript" src="<?php echo esc_url( home_url( '/' ) .'wp-content/themes/tara/js/jquery.easy_slides.js'); ?>"></script>
        <link rel="stylesheet" type="text/css" href="<?php echo esc_url( home_url( '/' ) .'wp-content/themes/tara/js/jquery.easy_slides.css'); ?>"/>
    </div>
    <!--div class="motasl">
        <div class="wrap-content">
            <div class="textsl" id="text1"><?php //echo $text1; ?></div>
            <div class="textsl" id="text2"><?php //echo $text2; ?></div>
        </div>
    </div-->
          <?php 
   } 
    // Widget Backend
    public function form($instance){
        $title = (isset($instance['title'])) ? $instance['title'] : __( 'Products', 'ndb' );
        $ids = $instance['ids'];
        $text= $instance['text'];
        $text1= $instance['text1'];
        $text2= $instance['text2'];
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"  name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('ids'); ?>"><?php _e('Category:'); ?></label>
            <textarea rows="16" cols="20" class="widefat" id="<?php echo $this->get_field_id( 'text' ); ?>" name="<?php echo $this->get_field_name( 'text' ); ?>" class="text sync-input" ><?php echo esc_textarea( $instance['text'] ); ?></textarea>
            
        </p>
        <p>
            <input class="widefat" id="<?php echo $this->get_field_id('text1'); ?>"  name="<?php echo $this->get_field_name( 'text1' ); ?>" type="text" value="<?php echo esc_attr( $text1); ?>" />
        </p>
        <p>
            <input class="widefat" id="<?php echo $this->get_field_id('text2'); ?>"  name="<?php echo $this->get_field_name( 'text2' ); ?>" type="text" value="<?php echo esc_attr( $text2); ?>" />
        </p>
        <?php

    }
    public function update( $new_instance, $old_instance ) {
       $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['ids'] = ( ! empty( $new_instance['ids'] ) ) ? strip_tags( $new_instance['ids'] ) : '';
        if ( current_user_can( 'unfiltered_html' ) ) {
			$instance['text'] = $new_instance['text'];
		} else {
			$instance['text'] = wp_kses_post( $new_instance['text'] );
		}
        $instance['text1'] = $new_instance['text1'];
        $instance['text2'] = $new_instance['text2'];
        return $instance;
    }
}
add_action( 'widgets_init', function(){
    register_widget( 'slide_quyen' );
} );
?>