<?php
/*
 * Plugin Name: Slide Image
 * Plugin URI: https://#
 * Description: Widget that displays the featured image of the current post.
 * Version: 1.0
 * Author: Quyen Ga
 * Author URI: https://#
 * License: Q
 * 
 * @package ng-sidebar-featured-image
 * @copyright Copyright (c) 2016, Quyen Ga.
 * @license Q
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
class slide_image extends WP_Widget
{
    function __construct()
    {
        parent::__construct(
                'slide_image',
                __( 'SLIDE Image', 'ctm' ),
                array('description' => __( 'This plugin displays a list of products of a certain category on your website 1.', 'ctm' )) 
                );
    }
    public function widget( $args, $instance ) {
        extract( $args );
        $title = apply_filters( 'widget_title', $instance['title']);
        $ids   = $instance['ids'];
        $text  = $instance['text'];
         ?>
      <div id="slide1">
        <div class="slider slider_one_big_picture1">
            <?php echo $text; ?>
         <div class="next_button"></div>  
          <div class="prev_button"></div>  
          <div class="nav_indicators"></div>
         </div>
         <script>
           $(document).ready(function() {
             $('.slider_one_big_picture1').EasySlides({'autoplay': true,'stepbystep':false, 'show': 5})
             $('.slider_circle_10').EasySlides({'autoplay': true, 'show': 13})
             $('.slider_four_in_line').EasySlides({'autoplay': true, 'show': 9})
             $('.slider_clock').EasySlides({'autoplay': true, 'show': 15})
        
           });
         </script>
         <style type="text/css">
           
          .slider_one_big_picture1 {
          position: relative;
          width: 100%;
          height: 29vw;
          margin: 0 auto;
          user-select: none;
          /*overflow: hidden;*/}
          .slider_one_big_picture1 > * {
    transition: ease all 1s;
}
.slider_one_big_picture1 .hidden {
    opacity: 0;
    position: absolute;
    top: 0px;
    left: 0px;
    width: 100%;
    height: 100%;
    z-index: 0;
}
.slider_one_big_picture1 .active {
    opacity: 1;
    position: absolute;
    top: 0px;
    left: 0%;
    width: 100%;
    height: 100%;
    z-index: 2;
}
.slider_one_big_picture1 .prev1,
.slider_one_big_picture1 .next1 {
    opacity: 0;
    position: absolute;
    top: 0px;
    left: 0%;
    width: 0px;
    height: 100%;
    z-index: 0;
}
.slider_one_big_picture1 .next1 {
    left: 100%;
}
.slider_one_big_picture1 .prev2,
.slider_one_big_picture1 .next2 {
    opacity: 0;
    position: absolute;
    top: 0px;
    left: 0%;
    width: 0px;
    height: 100%;
    z-index: 0;
}
.slider_one_big_picture1 .next2 {
    left: 100%;
}
         </style>
        <script type="text/javascript" src="<?php echo esc_url( home_url( '/' ) .'wp-content/themes/tara/js/jquery.easy_slides.js'); ?>"></script>
        <link rel="stylesheet" type="text/css" href="<?php echo esc_url( home_url( '/' ) .'wp-content/themes/tara/js/jquery.easy_slides.css'); ?>"/>
    </div>
    <!--div class="motasl">
        <div class="wrap-content">
            <div class="textsl" id="text1"><?php //echo $text1; ?></div>
            <div class="textsl" id="text2"><?php //echo $text2; ?></div>
        </div>
    </div-->
          <?php 
   } 
    // Widget Backend
    public function form($instance){
        $title = (isset($instance['title'])) ? $instance['title'] : __( 'Products', 'ndb' );
        $ids = $instance['ids'];
        $text= $instance['text']; ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"  name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('ids'); ?>"><?php _e('Category:'); ?></label>
            <textarea rows="16" cols="20" class="widefat" id="<?php echo $this->get_field_id( 'text' ); ?>" name="<?php echo $this->get_field_name( 'text' ); ?>" class="text sync-input" ><?php echo esc_textarea( $instance['text'] ); ?></textarea>
            
        </p>

        <?php

    }
    public function update( $new_instance, $old_instance ) {
       $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['ids'] = ( ! empty( $new_instance['ids'] ) ) ? strip_tags( $new_instance['ids'] ) : '';
        if ( current_user_can( 'unfiltered_html' ) ) {
			$instance['text'] = $new_instance['text'];
		} else {
			$instance['text'] = wp_kses_post( $new_instance['text'] );
		}
        return $instance;
    }
}
add_action( 'widgets_init', function(){
    register_widget( 'slide_image' );
} );
?>